/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////
//
// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

float aspect = iResolution.x / iResolution.y;

//

bool IsLessThan( vec3 a, vec3 b )
{
    return ( a.x <= b.x || a.y <= b.y || a.z <= b.z );
}

vec3 SRGBToLinear( in vec3 sRGBCol )
{
   vec3 linearRGBLo = sRGBCol / 12.92;
   vec3 linearRGBHi = pow( ( sRGBCol + 0.055 ) / 1.055, vec3( 2.4 ) );
   vec3 linearRGB = IsLessThan( sRGBCol, vec3( 0.04045 ) ) ? linearRGBLo : linearRGBHi;
   return linearRGB;
}

vec3 linearToSRGB( in vec3 linearCol )
{
   vec3 sRGBLo = linearCol * 12.92;
   vec3 sRGBHi = ( pow( abs ( linearCol ), vec3( 1.0 / 2.4 ) ) * 1.055 ) - 0.055;
   vec3 sRGB   = IsLessThan( linearCol, vec3( 0.0031308 ) ) ? sRGBLo : sRGBHi;
   return sRGB; //pow( linearCol, vec3( 1.0 / 2.2 ) );
}

//

const int samples = 2;
const float fSamples = float( samples * samples * 2 * 2 );

void main( void )
 {
   float scale = 50.0;//( 0.4 + sin( iGlobalTime * 0.5 ) * 0.2 ) * 110.0;
   vec2 uv = gl_FragCoord.xy / iResolution.xy;
   
   uv.x *= aspect;
   uv.y *= -1.0;

   vec2 mosaicUV = floor( uv * scale ) / scale;
   uv  -= mosaicUV;
   uv  *= scale;

   vec2 triOffset = vec2(
       step( 1.0 - uv.y, uv.x ) / ( 2.0 * scale ),
       step(       uv.x, uv.y ) / ( 2.0 * scale )
   );

   vec2 sampleUV = mosaicUV + triOffset;
   sampleUV.x /= aspect;

   vec3 sample = vec3( 0.0 );
   for( int x = -samples; x < samples; x++ )
   {
     for( int y = -samples; y < samples; y++ )
       {
           vec2 subSampleUV = sampleUV;
           subSampleUV += ( vec2( aspect, 1.0 ) / vec2( scale * fSamples ) )
               * vec2( float( samples + x ), float( samples + y ) );
        sample += SRGBToLinear( texture2D( iChannel0, subSampleUV ).rgb );
       }
   }
   sample /= fSamples;

   gl_FragColor = vec4( linearToSRGB( sample ), 1.0 );

 }